/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.init.data;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;

public class CoPLangData {
    private static final HashMap<Class<?>, EnumEntry> MAP = new HashMap();

    @SafeVarargs
    private static <T extends Info> void putLang(Class<T> cls, String str, T ... vals) {
        MAP.put(cls, new EnumEntry(str, (Info[])vals));
    }

    public static void addTranslations(RegistrateLangProvider pvd) {
        for (IDS id : IDS.values()) {
            pvd.add("curseofpandora." + id.id, id.def);
        }
        for (EnumEntry ent : MAP.values()) {
            for (Info e : ent.info()) {
                pvd.add(e.desc(), e.entry().def());
            }
        }
    }

    public static MutableComponent getDesc(MobEffectInstance ins) {
        return CoPLangData.getDesc(ins, true);
    }

    public static MutableComponent getDesc(MobEffectInstance ins, boolean showDuration) {
        MutableComponent desc = Component.m_237115_((String)ins.m_19576_());
        if (ins.m_19564_() > 0) {
            desc = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{desc, Component.m_237115_((String)("potion.potency." + ins.m_19564_()))});
        }
        if (showDuration && !ins.m_267633_(20)) {
            desc = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{desc, MobEffectUtil.m_267641_((MobEffectInstance)ins, (float)1.0f)});
        }
        return desc.m_130940_(ins.m_19544_().m_19483_().m_19497_());
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static MutableComponent translate(String key, Object ... objs) {
        return Component.m_237110_((String)key, (Object[])objs);
    }

    static {
        CoPLangData.putLang(Reality.class, (String)"curse", (Info[])Reality.values());
        CoPLangData.putLang(Angelic.class, (String)"angel", (Info[])Angelic.values());
        CoPLangData.putLang(Hell.class, (String)"hell", (Info[])Hell.values());
        CoPLangData.putLang(Shadow.class, (String)"shadow", (Info[])Shadow.values());
        CoPLangData.putLang(Elemental.class, (String)"elemental", (Info[])Elemental.values());
        CoPLangData.putLang(Abyssal.class, (String)"abyssal", (Info[])Abyssal.values());
        CoPLangData.putLang(Barbaric.class, (String)"barbaric", (Info[])Barbaric.values());
        CoPLangData.putLang(Mutation.class, (String)"mutation", (Info[])Mutation.values());
        CoPLangData.putLang(Evil.class, (String)"evil", (Info[])Evil.values());
        CoPLangData.putLang(Weapon.class, (String)"weapon", (Info[])Weapon.values());
        CoPLangData.putLang(Compat.class, (String)"compat", (Info[])Compat.values());
    }

    public record EnumEntry(String path, Info[] info) {
    }

    public static interface Info {
        public Entry entry();

        default public String path() {
            return MAP.get(this.getClass()).path();
        }

        default public String desc() {
            return "curseofpandora.tooltip." + this.path() + "." + this.entry().id();
        }

        default public MutableComponent get(Object ... objs) {
            if (objs.length != this.entry().count()) {
                throw new IllegalArgumentException("for " + this.entry().id() + ": expect " + this.entry().count() + " parameters, got " + objs.length);
            }
            return CoPLangData.translate(this.desc(), objs);
        }
    }

    public static enum IDS {
        EFFECT_REFRESH_CURIO("tooltip.misc.effect_refresh", "Grants wearer: ", 0),
        BIND("tooltip.misc.bind", "This item cannot be taken down.", 0),
        REALITY_INDEX("tooltip.misc.reality", "When you have at least %s Reality Index:", 1),
        KILL_DROPS("tooltip.misc.drop", "Dropped when %s kills %s", 2),
        KILL_DROP_CHANCE("tooltip.misc.drop_chance", "Dropped when %s kills %s, with %s%% chance", 3);

        final String id;
        final String def;
        final int count;

        private IDS(String id, String def, int count) {
            this.id = id;
            this.def = def;
            this.count = count;
        }

        public MutableComponent get(Object ... objs) {
            if (objs.length != this.count) {
                throw new IllegalArgumentException("for " + this.name() + ": expect " + this.count + " parameters, got " + objs.length);
            }
            return CoPLangData.translate("curseofpandora." + this.id, objs);
        }
    }

    public record Entry(String id, String def, int count) {
    }

    public static enum Reality implements Info
    {
        INERTIA("Negate all other non-tool attack speed bonus. Cap player attack speed to %s. When player attack speed is %s or lower, grant %s%% attack speed bonus.", 3),
        PROXIMITY("Negate all other non-tool attack reach bonus. Cap player attack reach to %s. When player attack reach is %s or lower, grant %s%% attack reach bonus.", 3),
        FLESH("Negate all max health bonus. If player maintains at least %s food level for %s minutes, grant +%s%% max health.", 3),
        METABOLISM_1("Gain %s%% attack and speed per food level above %s.", 2),
        METABOLISM_2("Loss %s%% attack, speed, and attack speed per food level below %s.", 2),
        METABOLISM_3("When food level is full, gain %s%% attack and speed, and negate all speed reduction", 1),
        TENSION_1("When you hit a target, place a Terror Token on it. Tokens take %s seconds to mature, then increase your damage to it by %s%% for %s seconds, stacking to at most %s levels.", 4),
        TENSION_2("When a mob deals you a damage higher than %s%% of your current health, all Terror Token from you breaks, and you cannot deal damage to that target for %s seconds", 2),
        PRUDENCE_1("When you hit a target, your damage to the same target for the next %s second will -%s%% (stackable).", 2),
        PRUDENCE_2("Your damage dealt against a target with health higher than you cannot exceed %s%% of target max health.", 1),
        SPELL_1("Enchantments on your weapons and armors will put a burden on you, hurt you, increase damage you take and reduce damage you dealt. Use equipments with high enchantment affinity and gain spell tolerance to mitigate that.", 0),
        SPELL_2("Current total spell overload: %s%%", 1),
        SPELL_3("Item spell load: %s%%", 1),
        SPELL_4("Item spell load: %1$s/(%2$s+%3$s)/%2$s*%4$s%%=%5$s%%", 5);

        final Entry entry;

        private Reality(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Angelic implements Info
    {
        CHECK("Effective only when player is under sky", 0),
        WING("When player is elytra flying, gives player a velocity boost.", 0),
        WING_IMMUNE("Player takes no damage for falling and flying into wall.", 0),
        DESCENT("All damage against undead mobs is increased by %s%%.", 1),
        PROTECTION("Works as an unbreakable totem of undying with a cool down of %s seconds.", 1),
        PUNISHMENT_1("All Angelic pandora charms triggers when not under sky as well.", 0),
        PUNISHMENT_2("Damage dealt to target will be at least %s%% of their current health. This effect can trigger at most once every %s seconds.", 2);

        final Entry entry;

        private Angelic(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Hell implements Info
    {
        SKULL("When you damage a target on Soul Flame effect with at least %s seconds duration, increase the effect level by 1, capped at your Reality Index.", 1),
        REFORMATION_1("You are immune to Soul Flame damage, but you are not immune to the effect even when you have Cleansed effect. ", 0),
        REFORMATION_2("When you deal damage to targets while you are on Soul Flame effect, inflict the target with same level and duration of Soul Flame", 0),
        EYE("When you damage a target, the target will deal a small magic damage to all monsters around it within %s blocks. Has a cool down of %s seconds.", 2),
        CRYSTAL("When you are attacked by non-undead mobs, redirect the attack to a random undead mob within %s blocks. Cool down: %s seconds.", 2),
        CROWN("All weak undead mobs around you will listen to your command.", 0);

        final Entry entry;

        private Hell(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Shadow implements Info
    {
        CORE_1("Inflict shadow effect on attack target with duration of %s seconds per your Reality Index.", 1),
        CORE_2("Shadow effect will reduce damage mobs dealt by %s%%", 1),
        CONVERGENCE("Heal %s%% of the damage you dealt to target with Shadow effect", 1),
        CONSOLIDATION("When you hit targets with shadow effect, after %3$s second, their shadow will scatter and attack surrounding mobs within %1$s blocks, dealing %2$s%% of original damage dealt. This effect can trigger once every %4$s seconds.", 4),
        REFORMATION_1("+%s%% magic damage against target with Shadow effect", 1),
        REFORMATION_2("-%s%% physical damage from mobs with Shadow effect", 1),
        VOID("Shadow damage you dealt becomes void shadow damage.", 0);

        final Entry entry;

        private Shadow(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Elemental implements Info
    {
        WIND_1("Effective only when player is sprinting", 0),
        WIND_2("Automatically attack aimed targets", 0),
        EARTH("Effective only when player attack speed is %s or lower", 1),
        WAVING("Effective only when player is in water or rain", 0),
        CURSE_1("Gain 1 Spell Tolerance for every armors with curse enchantment.", 0),
        CURSE_2("+%s%% magic damage for every curse enchantment on your armors.", 1);

        final Entry entry;

        private Elemental(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Abyssal implements Info
    {
        TREASURE("For every %s blocks below 0, you gain 1 Luck", 1),
        WATCHER("For every %s blocks below 0, you gain %s%% regeneration per second", 2),
        SHELL("For every %s blocks below 0, you gain +%s%% Armor and Armor Toughness", 2),
        CROWN("For every %s blocks below 0, you gain +%s%% chance for melee damage to bypass magic", 2),
        WILL("Reduce depth requirement for Abyssal pandora charms", 0),
        WILL_TOTEM("When taking fatal damage, retain 1 health and be immune to magic-bypassing damage for the next %s seconds. Cool down: %s seconds.", 2),
        WILL_RESTRICT("When you are above y=0, it only works for magic-bypassing damage.", 0);

        final Entry entry;

        private Abyssal(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Barbaric implements Info
    {
        INSTINCT("When player hit target with weapon, heal %s%% of player max health. Cool Down: %s seconds", 2),
        PRIMAL_1("Gain armor equal to %s%% of your max health", 1),
        PRIMAL_2("When you are hit by mobs, those mobs gain armor equal to %s%% of their max health", 1);

        final Entry entry;

        private Barbaric(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static final class Mutation
    extends Enum<Mutation>
    implements Info {
        final Entry entry;
        private static final /* synthetic */ Mutation[] $VALUES;

        public static Mutation[] values() {
            return (Mutation[])$VALUES.clone();
        }

        public static Mutation valueOf(String name) {
            return Enum.valueOf(Mutation.class, name);
        }

        private Mutation(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }

        private static /* synthetic */ Mutation[] $values() {
            return new Mutation[0];
        }

        static {
            $VALUES = Mutation.$values();
        }
    }

    public static enum Evil implements Info
    {
        RITUAL("Mobs you kills drop extra exp, equals to %s%% of their max health", 1),
        EVOKE_CONVERT("Vex that attempts to attack you will be converted to Evil Spirit and attacks their original summoner.", 0),
        EVOKE("When you are hit, summons Vex to fight for you. Each lasts %s seconds. Cool down: %s seconds", 2),
        AWAKENING("When you kills enemy, gain %s%% magic damage and %s%% damage reduction for %s seconds, stacking up to %s level", 4),
        CURSE("Magic damage against mobs with %s%% or lower health increases by %s%%", 2),
        WALK("Evil spirit possess you. Gain %s%% magic and %s%% attack damage bonus. When taking fatal damage, restore full health and exit possession mode for %s seconds.", 3);

        final Entry entry;

        private Evil(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Weapon implements Info
    {
        ANGELIC_JUDGEMENT("Empty slash shoots 5 piercing magic blades. When sneaking, blades are more concentrated.", 0),
        DOOM_STAR("Empty slash shoots shadow blade", 0),
        CURSED_KARMA("Empty slash shoots explosive cursed flaming blade", 0),
        ABYSSAL_EDGE("Slash summons abyssal fangs. Sneak slash summons them around you ", 0);

        final Entry entry;

        private Weapon(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }

    public static enum Compat implements Info
    {
        SEAL_OF_SWORDS("Gain 1 %s for every %s player difficulty level. At most gain %s %s", 4),
        SPELL_SINGULARITY_0("When none of your equipments have more enchantments than your %s:", 1),
        SPELL_SINGULARITY_1("Gain %s %s and %s %s for every %s", 5),
        EL_AGGREVATE("Negate 2nd Curse from the Cursed Ring. Feel free to make friends.", 0),
        EL_INSOMNIA("Negate 7th Curse from the Cursed Ring. Have a good night.", 0);

        final Entry entry;

        private Compat(String def, int count) {
            this.entry = new Entry(this.name().toLowerCase(Locale.ROOT), def, count);
        }

        @Override
        public Entry entry() {
            return this.entry;
        }
    }
}

